#!/opt/rh/ruby193/root/usr/bin/ruby
# This deploy hook gets executed after dependencies are resolved and the
# build hook has been run but before the application has been started back
# up again.  This script gets executed directly, so it could be python, php,
# ruby, etc.
# Change YOURUSER, YOURPASSWORD, CFMEIPADDRESS
# Update VMNAME to the vm you want to use

require 'savon'
require 'httpi'
require 'httpclient'
require 'openssl'
require 'pp'

module DCA
  class Worker
    def initialize
    end
    def build_automation_request(body_hash)
      # Require Savon Ruby Gem
      #HTTPI.log_level = debug # changing the log level
      #HTTPI.log = false
      #HTTPI.adapter = :net_http # [:httpclient, :curb, :net_http]
      # Setup Savon Configuration
      #Savon.configure do |config|
      #  config.log = false
      #  config.log_level = ebug # changing the log level
      #end
      client = Savon.client(basic_auth: ["YOURUSER", "YOURPASSWORD"], ssl_verify_mode: :none, ssl_version: :TLSv1, wsdl: "https://CFMEIPADDRESS/vmdbws/wsdl")
      #evm_response = client.request :vm_provision_request do
      evm_response = client.call(:vm_provision_request, message: body_hash)
    end
    # @param [Integer] memory The number of MegaBytes of memory to allocate to this VM.  ie. 4096
    def deploy_vm(template_name, vlan, ip, subnet, gateway, vm_name, domain_name, memory, cpus, add_disk, owner_email, customization_spec = 'linux')
      templateFields = []
      templateFields << "name=#{template_name}"
      templateFields << "request_type=template"
      vmFields = []
      vmFields << "vm_name=#{vm_name}"
      vmFields << "number_of_vms=1"
      vmFields << "vm_memory=#{memory}"
      vmFields << "number_of_cpus=#{cpus}"
#      The options below are useful for 
#      options = []
#      options << "sysprep_custom_spec=#{customization_spec}"
#      options << "sysprep_spec_override=true"
#      options << "sysprep_domain_name=#{domain_name}"
      vmFields << "addr_mode=static"
      vmFields << "ip_addr=#{ip}"
      vmFields << "subnet_mask=#{subnet}"
      vmFields << "gateway=#{gateway}"
      vmFields << "vlan=#{vlan}"
      vmFields << "provision_type=PXE"
      requester = []
      #requester << "user_name=#{user_id}"
      requester << "owner_email=#{owner_email}"
      tags = []
      #options << "add_vdisk1=#{add_disk}"
      input =  {
          'version'        =>        '1.1',
          'templateFields'        =>        templateFields.join('|'),
          'vmFields'        =>        vmFields.join('|'),
          'requester'        =>        requester.join('|'),
          'tags'        =>        tags.join('|'),
          #'options'        =>        options
      }
      pp input
      response = build_automation_request(input)
      pp response
    end
  end
end
w = DCA::Worker.new
r = w.deploy_vm("win2k8tmpl", "VM Network", "172.28.158.125", "255.255.255.128", "172.28.158.1",
                "VMNAME", "sys.mycustomer.net", 2048, 2, 15, "jlabocki@redhat.com", "linux")
puts "Guess what! I built me a vm! #{r}"
